import type { Icons } from "@/components/ui/icons";
import type { Link } from "@tanstack/react-router";
import { ComponentProps } from "react";

export type NavigationItem = Pick<ComponentProps<typeof Link>, "to"> & {
    title: string,
    disabled: boolean,
    external?: boolean,
    icon?: keyof typeof Icons,
    label?: string
}

export type SidebarNavigationItem = Pick<NavigationItem, "title"> & {
    items: NavigationItem[]
}